Import-Module Microsoft.Graph.DeviceManagement

####################################################
<# region Authentication
To authenticate, you'll use the Microsoft Graph PowerShell SDK. If you haven't already installed the SDK, see this guide:
https://learn.microsoft.com/en-us/powershell/microsoftgraph/installation?view=graph-powershell-1.0

The PowerShell SDK supports two types of authentication: delegated access, and app-only access.

For details on using delegated access, see this guide here:
https://learn.microsoft.com/powershell/microsoftgraph/get-started?view=graph-powershell-1.0

For details on using app-only access for unattended scenarios, see Use app-only authentication with the Microsoft Graph PowerShell SDK:
https://learn.microsoft.com/powershell/microsoftgraph/app-only?view=graph-powershell-1.0&tabs=azure-portal

#>
#endregion

####################################################

$windows = @"

{
    "@odata.type":  "#microsoft.graph.windows10CustomConfiguration",
    "DisplayName":  "DoD Adobe Acrobat Pro DC Continuous STIG v2r1 Custom Profile",
    "omaSettings":  [
                       {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Enhanced security for standalone mode must be enabled",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Adobe Acrobat Pro DC Continuous~Policy~Cat_Adobe_Pro_DC~Cat_Preferences~Cat_Security/Enable_Enhanced_security_standalone",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cenabled/\u003e",
                            "displayName":  "STIG ID AADC-CN-000205"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Enhanced security for browser mode must be enabled",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Adobe Acrobat Pro DC Continuous~Policy~Cat_Adobe_Pro_DC~Cat_Preferences~Cat_Security/Enable_Enhanced_security_inbrowser",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cenabled/\u003e",
                            "displayName":  "STIG ID AADC-CN-000210"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "PDF file attachments must be blocked",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Adobe Acrobat Pro DC Continuous~Policy~Cat_Adobe_Pro_DC~Cat_Preferences~Cat_TrustManager/Non_PDF_attachments",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cdisabled/\u003e",
                            
                            "displayName":  "STIG ID AADC-CN-000275"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Access to unknown websites must be restricted",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Adobe Acrobat Pro DC Continuous~Policy~Cat_Adobe_Pro_DC~Cat_Preferences~Cat_TrustManager/Access_to_unknown_websites",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cenabled/\u003e \u003cdata id=\"Access_to_unknown_websitesDropID\" value=\"3\"/\u003e",
                            
                            "displayName":  "STIG ID AADC-CN-000280"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Access to websites must be blocked",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Adobe Acrobat Pro DC Continuous~Policy~Cat_Adobe_Pro_DC~Cat_Preferences~Cat_TrustManager/Access_to_websites",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cenabled/\u003e \u003cdata id=\"Access_to_websitesDropID\" value=\"1\"/\u003e",
                            
                            "displayName":  "STIG ID AADC-CN-000285"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Block flash content",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Adobe Acrobat Pro DC Continuous~Policy~Cat_Adobe_Pro_DC~Cat_Preferences/Enable_Flash",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cdisabled/\u003e",
                            
                            "displayName":  "STIG ID AADC-CN-000290"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Send and track plugin for Outlook must be disabled",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Adobe Acrobat Pro DC Continuous~Policy~Cat_Adobe_Pro_DC~Cat_Preferences/Send_and_Track_plugin",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cdisabled/\u003e",
                            
                            "displayName":  "STIG ID AADC-CN-000295"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Privilieged file and folder locations must be disabled",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Adobe Acrobat Pro DC Continuous~Policy~Cat_Adobe_Pro_DC~Cat_Preferences~Cat_Security/Privilege_folder_location",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cdisabled/\u003e",
                            
                            "displayName":  "STIG ID AADC-CN-000840"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "FIPS Mode must be enabled",
                            "omaUri":  "./User/Vendor/MSFT/Policy/Config/Adobe Acrobat Pro DC Continuous~Policy~Cat_Adobe_Pro_DC~Cat_Preferences/Enable_FIPS",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cenabled/\u003e",
                            
                            "displayName":  "STIG ID AADC-CN-000955"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Adobe European certificates must be disabled",
                            "omaUri":  "./User/Vendor/MSFT/Policy/Config/Adobe Acrobat Pro DC Continuous~Policy~Cat_Adobe_Pro_DC~Cat_Preferences~Cat_TrustManager/European_certificates",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cdisabled/\u003e",
                            
                            "displayName":  "STIG ID AADC-CN-000990"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Protected mode must be enabled",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Adobe Acrobat Pro DC Continuous~Policy~Cat_Adobe_Pro_DC~Cat_Preferences/Protected_Mode",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cenabled/\u003e",
                            
                            "displayName":  "STIG ID AADC-CN-001010"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Protected view must be enabled",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Adobe Acrobat Pro DC Continuous~Policy~Cat_Adobe_Pro_DC~Cat_Preferences~Cat_Security/Protected_View",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cenabled/\u003e \u003cdata id=\"Protected_ViewDropID\" value=\"2\"/\u003e",
                            
                            "displayName":  "STIG ID AADC-CN-001015"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Default handler changes must be disabled",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Adobe Acrobat Pro DC Continuous~Policy~Cat_Adobe_Pro_DC~Cat_Preferences~Cat_General/Disable_PDF_handler",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cenabled/\u003e",
                            
                            "displayName":  "STIG ID AADC-CN-001280"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Disable the ability to store files an Acrobat.com",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Adobe Acrobat Pro DC Continuous~Policy~Cat_Adobe_Pro_DC~Cat_Preferences/Store_files",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cdisabled/\u003e",
                            
                            "displayName":  "STIG ID AADC-CN-001285"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Cloud sybchronization must be disabled",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Adobe Acrobat Pro DC Continuous~Policy~Cat_Adobe_Pro_DC~Cat_Preferences/Cloud_Synchronization",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cdisabled/\u003e",
                            
                            "displayName":  "STIG ID AADC-CN-001290"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Repair installation must be disabled 32-bit",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Adobe Acrobat Pro DC Continuous~Policy~Cat_Adobe_Pro_DC~Cat_Preferences~Cat_Help/Repair_installation_32",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cdisabled/\u003e",
                            
                            "displayName":  "STIG ID AADC-CN-001295 32-bit"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Repair installation must be disabled 64-bit",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Adobe Acrobat Pro DC Continuous~Policy~Cat_Adobe_Pro_DC~Cat_Preferences~Cat_Help/Repair_installation_64",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cdisabled/\u003e",
                            
                            "displayName":  "STIG ID AADC-CN-001295 64-bit"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Third party web connection must be disabled",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Adobe Acrobat Pro DC Continuous~Policy~Cat_Adobe_Pro_DC~Cat_Preferences/Web_connectors",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cdisabled/\u003e",
                            
                            "displayName":  "STIG ID AADC-CN-001300"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Webmail must be disabled",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Adobe Acrobat Pro DC Continuous~Policy~Cat_Adobe_Pro_DC~Cat_Preferences/WebMail",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cdisabled/\u003e",
                            
                            "displayName":  "STIG ID AADC-CN-001305"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Welcome screen must be disabled",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Adobe Acrobat Pro DC Continuous~Policy~Cat_Adobe_Pro_DC~Cat_Preferences/WelcomeScreen",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cdisabled/\u003e",
                            
                            "displayName":  "STIG ID AADC-CN-001310"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "SharePoint and Office365 access must be disabled",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Adobe Acrobat Pro DC Continuous~Policy~Cat_Adobe_Pro_DC~Cat_Preferences/Cloud_features",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cdisabled/\u003e",
                            
                            "displayName":  "STIG ID AADC-CN-001315"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Periodic downloading of Adobe certificates must be disabled",
                            "omaUri":  "./User/Vendor/MSFT/Policy/Config/Adobe Acrobat Pro DC Continuous~Policy~Cat_Adobe_Pro_DC~Cat_Preferences~Cat_TrustManager/Adobe_certificates",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cdisabled/\u003e",
                            
                            "displayName":  "STIG ID AADC-CN-001320"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Privileged host locations must be disabled",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Adobe Acrobat Pro DC Continuous~Policy~Cat_Adobe_Pro_DC~Cat_Preferences~Cat_Security/Trusted_Host",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cdisabled/\u003e",
                            
                            "displayName":  "STIG ID AADC-CN-001325"
                        }
                                        
                    ]

}

"@

####################################################

New-MgDeviceManagementDeviceConfiguration -BodyParameter $Windows